<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DonationRequest extends Model 
{

    protected $table = 'donation_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function bloodTypes()
    {
        return $this->hasMany('App\Models\BloodType', 'blood_type_id');
    }

    public function cities()
    {
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function clients()
    {
        return $this->belongsTo('App\Models\Client', 'client_id');
    }

    public function notifications()
    {
        return $this->belongsTo('App\Models\Notification');
    }

}